import java.math.BigInteger;

public class Hilfsmethoden {
    
    // Methoden zur String-Manipulation
    
    /**
     * Erzeugt den Wert eines BigIntegers als String in Hexadezimalnotation.
     * @param number die umzuwandelnde Zahl
     * @return der Wert der Zahl in Hexadezimalnotation
     */
    static String bigIntegerToHex(BigInteger number) {
        return number.toString(16);
    }

    /**
     * Nimmt einen String und wandelt ihn in eine BigInteger um
     * @param eingabe der umzuwandelnde Text
     * @return das Aequivalent als Zahl
     */
    static BigInteger asciiToBigInteger(String eingabe) {
        BigInteger ergebnis = new BigInteger("0");
        for (int i = 0; i<eingabe.length(); i++) {
            int c = eingabe.charAt(i);
            ergebnis = ergebnis.shiftLeft(8).add(new BigInteger(Integer.toString(c))); 
        }
        return ergebnis;
    }

    /**
     * Wandelt einen geradzahligen String von Hexadezimalzeichen um in das Ascii-Aequivalent - ohne Ueberpruefung auf syntaktische Korrektheit
     * @param hex der umzuwandelnde Hexadezimalstring
     * @return das Aequivalent als Ascii-Text
     */
      static String hexToAscii(String hex) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < hex.length(); i+=2) {
            String str = hex.substring(i, i+2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }
    
    // Methoden zum Ver- und Entschluesseln
    
    /**
     * Verschluesselt einen Textstring durch XOR mit einem Schluesselwort
     * @param klartext der umzuwandelnde Text
     * @param w das Schluesselwort, das mindestens so lang sein sollte wie der Klartext
     * @return das Ergebnis von XOR in Hexadezimalform
     */
      static String verschluesseln(String klartext, BigInteger w) {
        BigInteger klartextZahl = Hilfsmethoden.asciiToBigInteger(klartext);
        BigInteger ergebnisZahl = klartextZahl.xor(w);
        return Hilfsmethoden.bigIntegerToHex(ergebnisZahl);
    }

    /**
     * Entschluesselt einen Hexadezimal-Textstring durch XOR mit einem Hexadezimalstring-Schluesselwort
     * @param klartext der zu entschluesselnde String als Folge von Hexadezimalziffern
     * @param w das Schluesselwort
     * @return das Ergebnis von XOR, umgewandelt in Ascii
     */
      static String entschluesseln (String geheimtextHex, String schluesselHex) {
        BigInteger geheimtextZahl = new BigInteger(geheimtextHex, 16);
        BigInteger schluesselZahl = new BigInteger(schluesselHex, 16);        
        String ergebnisHex = Hilfsmethoden.bigIntegerToHex(geheimtextZahl.xor(schluesselZahl));
        return Hilfsmethoden.hexToAscii(ergebnisHex);
    }
    
    /**
     * Entschluesselt einen Hexadezimal-Textstring durch XOR mit einer Schluesselzahl
     * @param geheimtextHex der zu entschluesselnde String als Folge von Hexadezimalziffern
     * @param w die Schluesselzahl
     * @return das Ergebnis von XOR, umgewandelt in Ascii
     */
    static String entschluesseln (String geheimtextHex, BigInteger w) {
        String wInHex = Hilfsmethoden.bigIntegerToHex(w);
        return entschluesseln(geheimtextHex, wInHex);
    }
}
